/*
 * Decompiled with CFR 0.152.
 */
package filenet.ws.api.uddi;

import filenet.vw.base.logging.Logger;
import filenet.ws.api.uddi.WSBusinessService;
import filenet.ws.api.uddi.WSTModel;
import filenet.ws.api.uddi.WSUDDIRegistry;
import java.util.Vector;
import org.apache.juddi.datatype.CategoryBag;
import org.apache.juddi.datatype.Description;
import org.apache.juddi.datatype.DiscoveryURLs;
import org.apache.juddi.datatype.IdentifierBag;
import org.apache.juddi.datatype.Name;
import org.apache.juddi.datatype.business.BusinessEntity;
import org.apache.juddi.datatype.business.Contacts;
import org.apache.juddi.datatype.response.BusinessDetail;
import org.apache.juddi.datatype.response.BusinessInfo;
import org.apache.juddi.datatype.service.BusinessService;
import org.apache.juddi.datatype.service.BusinessServices;

public class WSBusinessEntity {
    protected static Logger logger = Logger.getLogger("filenet.ws.api.uddi");
    protected static final String m_className = "WSBusinessEntity";
    private WSUDDIRegistry m_uddiRegistry = null;
    private BusinessInfo m_businessInfo = null;
    private BusinessDetail m_businessDetail = null;
    private String m_businessKey = null;
    private BusinessEntity m_businessEntity = null;
    private DiscoveryURLs m_discoveryURLs = null;
    private Vector m_discoveryURLVector = null;
    private IdentifierBag m_identifierBag = null;
    private Vector m_identifierVector = null;
    private CategoryBag m_categoryBag = null;
    private Vector m_categoryVector = null;
    private BusinessServices m_businessServices = null;
    private Vector m_businessServiceVector = null;

    public WSBusinessEntity(WSUDDIRegistry uddiRegistry, BusinessInfo businessInfo) {
        this.m_uddiRegistry = uddiRegistry;
        this.m_businessInfo = businessInfo;
    }

    public WSBusinessEntity(WSUDDIRegistry uddiRegistry, String businessKey) throws Exception {
        this.m_uddiRegistry = uddiRegistry;
        this.m_businessKey = businessKey;
        this.getBusinessEntity();
    }

    public WSBusinessEntity(WSUDDIRegistry uddiRegistry, BusinessEntity uddiBusinessEntity) throws Exception {
        this.m_uddiRegistry = uddiRegistry;
        this.m_businessEntity = uddiBusinessEntity;
        this.m_businessKey = uddiBusinessEntity.getBusinessKey();
        this.getBusinessEntity();
    }

    public WSUDDIRegistry getWSUDDIRegistry() {
        return this.m_uddiRegistry;
    }

    private BusinessDetail getBusinessDetail() throws Exception {
        Object obj;
        Vector businessEntityVector;
        if (this.m_businessDetail == null && this.m_uddiRegistry != null) {
            if (this.m_businessInfo != null) {
                this.m_businessDetail = this.m_uddiRegistry.getBusinessDetail(this.m_businessInfo);
            } else if (this.m_businessKey != null && this.m_businessKey.length() > 0) {
                this.m_businessDetail = this.m_uddiRegistry.getBusinessDetail(this.m_businessKey);
            }
        }
        if (this.m_businessDetail != null && (businessEntityVector = this.m_businessDetail.getBusinessEntityVector()) != null && businessEntityVector.size() > 0 && (obj = businessEntityVector.elementAt(0)) != null && obj instanceof BusinessEntity) {
            this.m_businessEntity = (BusinessEntity)obj;
        }
        return this.m_businessDetail;
    }

    public boolean hasBusinessKey() throws Exception {
        String key = this.getBusinessKey();
        return key != null && key.length() > 0;
    }

    public void refresh() {
        String m_method = "refresh(): getBusinessEntity";
        if ((this.m_businessKey == null || this.m_businessKey.length() == 0) && this.m_businessEntity != null) {
            this.m_businessKey = this.m_businessEntity.getBusinessKey();
        }
        this.m_businessDetail = null;
        this.m_businessEntity = null;
        this.m_businessServices = null;
        this.m_businessServiceVector = null;
        try {
            this.getBusinessEntity();
        }
        catch (Exception ex) {
            logger.throwing(m_className, m_method, ex);
        }
    }

    public BusinessEntity getBusinessEntity() throws Exception {
        if (this.m_businessEntity == null) {
            this.getBusinessDetail();
        }
        return this.m_businessEntity;
    }

    public void setBusinessEntity(BusinessEntity businessEntity) {
        this.m_businessEntity = businessEntity;
    }

    public Name getName(int index) {
        Vector v = this.getNameVector();
        if (v != null && v.size() > index && v.get(index) != null && v.get(index) instanceof Name) {
            return (Name)v.get(index);
        }
        return null;
    }

    public String getNameString(int index) {
        Vector v = this.getNameVector();
        if (v != null && v.size() > index && v.get(index) != null && v.get(index) instanceof Name) {
            return ((Name)v.get(index)).getValue();
        }
        return null;
    }

    public Vector getNameVector() {
        if (this.m_businessInfo != null) {
            return this.m_businessInfo.getNameVector();
        }
        if (this.m_businessEntity != null) {
            return this.m_businessEntity.getNameVector();
        }
        return null;
    }

    public void setNameVector(Vector names) {
        if (this.m_businessEntity != null) {
            this.m_businessEntity.setNameVector(names);
        }
    }

    public String toString() {
        if (this.getName(0) != null) {
            return this.getName(0).getValue();
        }
        return null;
    }

    public String getDescription() {
        Vector v = this.getDescriptionVector();
        if (v != null && v.size() > 0 && v.get(0) != null && v.get(0) instanceof Description) {
            return ((Description)v.get(0)).getValue();
        }
        return null;
    }

    public Vector getDescriptionVector() {
        if (this.m_businessInfo != null) {
            return this.m_businessInfo.getDescriptionVector();
        }
        if (this.m_businessEntity != null) {
            return this.m_businessEntity.getDescriptionVector();
        }
        return null;
    }

    public void setDescriptionVector(Vector descriptions) {
        if (this.m_businessEntity != null) {
            this.m_businessEntity.setDescriptionVector(descriptions);
        }
    }

    public String getAuthorizedName() throws Exception {
        this.getBusinessEntity();
        if (this.m_businessEntity != null) {
            return this.m_businessEntity.getAuthorizedName();
        }
        return null;
    }

    public String getBusinessKey() throws Exception {
        this.getBusinessEntity();
        if (this.m_businessEntity != null) {
            return this.m_businessEntity.getBusinessKey();
        }
        return null;
    }

    public Vector getDiscoveryURLs() throws Exception {
        if (this.m_discoveryURLs == null) {
            this.getBusinessEntity();
            if (this.m_businessEntity != null) {
                this.m_discoveryURLs = this.m_businessEntity.getDiscoveryURLs();
                if (this.m_discoveryURLs != null) {
                    this.m_discoveryURLVector = this.m_discoveryURLs.getDiscoveryURLVector();
                }
            }
        }
        return this.m_discoveryURLVector;
    }

    public Contacts getContacts() throws Exception {
        Contacts oContacts = null;
        if (this.m_businessEntity == null) {
            this.getBusinessEntity();
        }
        if (this.m_businessEntity != null) {
            oContacts = this.m_businessEntity.getContacts();
        }
        return oContacts;
    }

    public void setContacts(Contacts contacts) throws Exception {
        if (this.m_businessEntity == null) {
            this.getBusinessEntity();
        }
        if (this.m_businessEntity != null) {
            this.m_businessEntity.setContacts(contacts);
        }
    }

    public Vector getContactVector() throws Exception {
        Contacts oContacts = this.getContacts();
        Vector contactVector = null;
        if (oContacts != null) {
            contactVector = oContacts.getContactVector();
        }
        return contactVector;
    }

    public Vector getIdentifiers() throws Exception {
        if (this.m_identifierVector == null && this.m_identifierBag == null) {
            this.getBusinessEntity();
            if (this.m_businessEntity != null) {
                this.m_identifierBag = this.m_businessEntity.getIdentifierBag();
                this.m_identifierVector = this.m_identifierBag.getKeyedReferenceVector();
            }
        }
        return this.m_identifierVector;
    }

    public Vector getCategories() throws Exception {
        if (this.m_categoryVector == null && this.m_categoryBag == null) {
            this.getBusinessEntity();
            if (this.m_businessEntity != null) {
                this.m_categoryBag = this.m_businessEntity.getCategoryBag();
                this.m_categoryVector = this.m_categoryBag.getKeyedReferenceVector();
            }
        }
        return this.m_categoryVector;
    }

    public Vector getBusinessServices() throws Exception {
        if (this.m_businessServiceVector == null && this.m_businessServices == null) {
            this.m_businessServiceVector = new Vector();
            this.getBusinessEntity();
            if (this.m_businessEntity != null) {
                Vector v;
                this.m_businessServices = this.m_businessEntity.getBusinessServices();
                if (this.m_businessServices != null && (v = this.m_businessServices.getBusinessServiceVector()) != null && v.size() > 0) {
                    for (int i = 0; i < v.size(); ++i) {
                        if (v.get(i) == null || !(v.get(i) instanceof BusinessService)) continue;
                        this.m_businessServiceVector.add(new WSBusinessService(this.m_uddiRegistry, this, (BusinessService)v.get(i)));
                    }
                }
            }
        }
        return this.m_businessServiceVector;
    }

    public Vector refreshBusinessServices() throws Exception {
        if (this.m_businessEntity != null && this.m_businessEntity.getBusinessKey() != null) {
            this.refresh();
            return this.getBusinessServices();
        }
        return null;
    }

    public Vector findServiceByName(String name) throws Exception {
        if (name == null) {
            return null;
        }
        Vector<WSBusinessService> matchedServices = new Vector<WSBusinessService>();
        Vector businessServices = this.getBusinessServices();
        if (businessServices != null && businessServices.size() > 0) {
            Object obj = null;
            WSBusinessService service = null;
            String aName = null;
            for (int i = 0; i < businessServices.size(); ++i) {
                obj = businessServices.get(i);
                if (obj == null || !(obj instanceof WSBusinessService) || (aName = (service = (WSBusinessService)obj).getName()) == null || aName.compareTo(name) != 0) continue;
                matchedServices.add(service);
            }
            if (matchedServices.size() > 0) {
                return matchedServices;
            }
        }
        return null;
    }

    public Vector getTModelKeys() throws Exception {
        Vector businessServices = this.getBusinessServices();
        Vector keys = new Vector();
        if (businessServices != null && businessServices.size() > 0) {
            Object obj = null;
            Object businessService = null;
            for (int i = 0; i < businessServices.size(); ++i) {
                obj = businessServices.get(i);
                if (obj == null || !(obj instanceof WSBusinessService)) continue;
                keys.addAll(((WSBusinessService)obj).getTModelKeys());
            }
        }
        return keys;
    }

    public WSTModel[] getTModels() throws Exception {
        Vector tModelKeys;
        if (this.m_uddiRegistry != null && (tModelKeys = this.getTModelKeys()) != null && tModelKeys.size() > 0) {
            return this.m_uddiRegistry.getTModels(tModelKeys);
        }
        return null;
    }
}

